const { con } = require("../db/conn");
const client = con;
const myController = {};
const validTables = ["hotels", "rooms", "transport", "packages", "users", "phtView"];
const sendEmailToAgent = require ("../dbTables/sendEmail");
const jwt = require("jsonwebtoken");


// // *******************Hotel API'S*********************

// // The Create API for all the tables , Remember to specify the table name when calling the CREATE API

myController.create = async (req, res) => {
  const { table, data } = req.body.payload;
  console.log("body", req.body);
  console.log("table name ", table);

  if (table === "packages") {
    const newData = {
      ...data,
      amenities: JSON.stringify(data.amenities),
      tag: JSON.stringify(data.tag),
      package_images: JSON.stringify(data.package_image),
      package_thumbnail: data.package_thumbnail,
    };

    console.log(newData);
    if (!validTables.includes(table)) {
      console.log("Invalid Table Name!");
      return res.status(400).json({ message: "Invalid Table Name!" });
    }

    con.getConnection(async function (err, conn) {
      if (err) {
        console.log("Error:", err);
      } else {
        try {
          const tableInfo = getTableInfo(table);

          if (!tableInfo) {
            console.log("Invalid Table Name");
            return res.status(400).json({ message: "Invalid Table Name!" });
          }

          const missingFields = tableInfo.columns.filter(
            (field) => !(field in newData)
          );
          if (missingFields.length > 0) {
            console.log("Invalid Data");
            return res.status(400).json({
              message: `Missing required fields: ${missingFields.join(", ")}`,
            });
          }

          const columns = tableInfo.columns.join(",");
          const placeholders = Array(tableInfo.columns.length)
            .fill("?")
            .join(",");
          const values = tableInfo.columns.map((field) => newData[field]);
          const insertQuery = `INSERT INTO ${tableInfo.tableName} (${columns}) VALUES (${placeholders})`;
          console.log(insertQuery);

          const [result] = await conn.promise().query(insertQuery, values);
          res.status(201).json({
            message: `Record of ${table} created successfully`,
            insertedId: result.insertId,
          });
        } catch (err) {
          console.log("Error:", err);
          return res.status(500).json({ message: err });
        } finally {
          conn.release();
        }
      }
    });
  } else {
    if (!validTables.includes(table)) {
      console.log("Invalid Table Name!");
      return res.status(400).json({ message: "Invalid Table Name!" });
    }
    con.getConnection(async function (err, conn) {
      if (err) {
        console.log("Error:", err);
      } else {
        try {
          const tableInfo = getTableInfo(table);

          if (!tableInfo) {
            console.log("Invalid Table Information!");
            return res
              .status(400)
              .json({ message: "Invalid Table Information!" });
          }

          const missingFields = tableInfo.columns.filter(
            (field) => !(field in data)
          );
          if (missingFields.length > 0) {
            console.log("Invalid Data");
            return res.status(400).json({
              message: `Missing required fields: ${missingFields.join(", ")}`,
            });
          }

          const columns = tableInfo.columns.join(",");
          const placeholders = Array(tableInfo.columns.length)
            .fill("?")
            .join(",");
          const values = tableInfo.columns.map((field) => data[field]);
          const insertQuery = `INSERT INTO ${tableInfo.tableName} (${columns}) VALUES (${placeholders})`;

          const [result] = await conn.promise().query(insertQuery, values);
          if (table === "users")
           {
              if(data.role === "agent")
              {
                console.log("Sending Email");
                const email = data.email;
                const password = data.password;
                const name= data.firstName;
                const message = `Hello ${name} , Greetings of the day \n\nHere is your Agent Credentials for the Hamrah Agent Login \n\nEmail: ${email} \nPassword: ${password} \n\nPlease login with your crendentials at https://beta.hamrah.pk/login \n\nPlease make sure to change your credentials by clicking on your name (appearing on the right corner) then select profile and click edit button, then enter your current and new password and click on save button. \n\n\nRegards\nSuper Admin,\nHamrah Team.`;
                await sendEmailToAgent({
                  email: email,
                  subject: 'Hamrah Agent Account Settings',
                  message
                });
              }

              res.status(201).json({
                message: "User Created Successfully",
              });
          } 
          else {
            res.status(201).json({
              message: `Record of ${table} created successfully`,
              insertedId: result.insertId,
            });
          }
          console.log(`Record of ${table} created successfully`);
        } catch (err) {
          console.log("Error:", err);
          return res.status(500).json({ message: err });
        } finally {
          conn.release();
        }
      }
    });
  }
};

// Function to retrieve table information based on the table name
function getTableInfo(tableName) {
  const tableInfo = {
    hotels: {
      tableName: "hotels",
      columns: [
        "name",
        "address",
        "city",
        "province",
        "focalperson",
        "contact",
        "email",
        "rating",
      ],
    },
    rooms: {
      tableName: "rooms",
      columns: [
        "rclass",
        "quantity",
        "available",
        "description",
        "rate",
        "hotelid",
      ],
    },
    transport: {
      tableName: "transport",
      columns: [
        "name",
        "make",
        "model",
        "vehicle_type",
        "seats",
        "exclusive",
        "rate",
        "focalperson",
        "contact",
        "email",
        "roundtrip",
      ],
    },
    packages: {
      tableName: "packages",
      columns: [
        "hotel_id",
        "package_name",
        "number_of_rooms",
        "room_class",
        "number_of_persons",
        "transport_service_id",
        "tag",
        "rate",
        "amenities",
        "package_description",
        "package_state",
        "package_images",
        "package_thumbnail",
        "location",
        "latitude",
        "longitude",
        "agentId",
        "tripDuration",
        "agentContact",
      ],
    },
    users: {
      tableName: "users",
      columns: ["firstName", "lastName", "email", "password", "role", "phone"],
    },
  };

  return tableInfo[tableName];
}

myController.updateRecord = async (req, res) => {
  const { table, id, ...updateFields } = req.body.payload.payLoad;
  console.log(table, id, updateFields);
  let newData = { ...updateFields };

  if (
    updateFields.hasOwnProperty("amenities") ||
    updateFields.hasOwnProperty("tag") ||
    updateFields.hasOwnProperty("package_images")
  ) {
    if (updateFields.hasOwnProperty("amenities")) {
      newData.amenities = JSON.stringify(updateFields.amenities);
      console.log("If Condition!!", newData);
    }
    if (updateFields.hasOwnProperty("tag")) {
      newData.tag = JSON.stringify(updateFields.tag);
      console.log("If Condition   2!!", newData);
    }
    if (updateFields.hasOwnProperty("package_images")) {
      newData.package_images = JSON.stringify(updateFields.package_images);
      console.log("If Condition   3!!", newData);
    }
  }

  // check if taking undefined values
  if (!table || !id || Object.keys(updateFields).length === 0) {
    return res.status(400).json({ message: "Please Provide Proper Details" });
  }

  // validate table check
  const validTables = ["hotels", "rooms", "transport", "packages", "users"];
  if (!validTables.includes(table)) {
    return res.status(400).json({ message: "Invalid table Name" });
  }

  con.getConnection(async function (err, conn) {
    if (err) {
      console.log("Error:", err);
    } else {
      try {
        const updateQueryParts = []; // column names of tables
        const queryParams = []; // value against each column name

        for (const field in newData) {
          // Use newData here instead of updateFields
          updateQueryParts.push(`${field} = ?`); // setting field=?
          queryParams.push(newData[field]); // pushing value of column in list
        }

        queryParams.push(id);
        console.log(updateQueryParts);
        const updateQuery = `UPDATE ${table} SET ${updateQueryParts.join(
          ","
        )} WHERE id = ?`;
        console.log(updateQuery, queryParams);

        conn.query(updateQuery, queryParams, (err, result) => {
          console.log("Updated Successfully!");
          res.status(202).json({ message: "Updated Successfully!" });
        });
      } catch (err) {
        console.log("Error in updating record:", err);
        res.status(500).json({ message: err });
      } finally {
        conn.release();
        console.log("Connection released");
      }
    }
  });
};


myController.delete = async (req, res) => {
  const { table, id } = req.body;
  console.log(table, id);

  // check if taking undefined values
  if (!table || !id ) {
    return res.status(400).json({ message: "Please Provide Proper Details" });
  }

  // validate table check
  const validTables = ["hotels", "rooms", "transport", "packages"];
  if (!validTables.includes(table)) {
    return res.status(400).json({ message: "Invalid table Name" });
  }

  con.getConnection(async function (err, conn) {
    if (err) {
      console.log("Error:", err);
    } else {
      try {
        const deleteQuery = `DELETE FROM ${table} WHERE id = ?`;

        conn.query(deleteQuery, id, (err, result) => {
          if(err)
          {
            res.status(404).json({message: err});
            console.log("Error : ", err);
          }
          else{
            console.log("Deleted Successfully!");
            res.status(202).json({ message: result });
          }
        });
      } catch (err) {
        console.log("Error in Deleting record:", err);
        res.status(500).json({ message: err });
      } finally {
        conn.release();
        console.log("Connection released");
      }
    }
  });
};

myController.filter = async (req, res) => {
  const { table, selectedfields, fields, values, search } = req.body;
  console.log(req.body);

  if (!table) {
    console.log("Table Name is Invalid!");
    res.status(400).json({ Error: "Table Name is Invalid!" });
  } else if (table && search) {
    if (!validTables.includes(table)) {
      console.log("Invalid table name");
      res.status(400).json({ Error: "Invalid table name" });
    }
    con.getConnection(async function (err, conn) {
      if (err) {
        console.log("Error:", err);
      } else {
        try {
          const searchTerms = search.split(" ");
          console.log("terms:", searchTerms);
          let nameSearch = constructSearchTerms(searchTerms, "package_name");
          let locationSearch = constructSearchTerms(searchTerms, "location");
          let tagSearch = constructSearchTerms(searchTerms, "tags");
          let amenitySearch = constructSearchTerms(searchTerms, "amenities");

          // searchTerms.map((term, i) => {
          //   if (i == 0) {
          //     nameSearch =
          //       nameSearch +
          //       `package_name SOUNDS LIKE '${term}' OR package_name LIKE '%${term}%'`;
          //     locationSearch =
          //       locationSearch +
          //       `location SOUNDS LIKE '${term}' OR location LIKE '%${term}%'`;
          //   } else {
          //     nameSearch =
          //       nameSearch +
          //       ` OR package_name SOUNDS LIKE '${term}' OR package_name LIKE '%${term}%'`;
          //     locationSearch =
          //       locationSearch +
          //       ` OR location SOUNDS LIKE '${term}' OR location LIKE '%${term}%'`;
          //   }
          // });

          const query = `SELECT package_id, package_name, rate, package_thumbnail, hotel_city, location, tags, number_of_persons FROM phtView WHERE ${nameSearch} OR ${locationSearch} OR ${tagSearch} OR ${amenitySearch} OR package_name SOUNDS LIKE '${search}' OR package_name LIKE '%${search}%'  OR rate<= '${search}' limit 5`;

          console.log(query);
          const [result] = await conn.promise().query(query);
          console.log("length:", result.length);
          res.json(result);
        } catch (error) {
          console.error("Error fetching records:", error);
          res.status(500).send(error);
        } finally {
          conn.release();
        }
      }
    });
  } else if (table && !selectedfields && !fields && !values) {
    if (!validTables.includes(table)) {
      console.log("Invalid table name");
      res.status(400).json({ Error: "Invalid table name" });
    }
    con.getConnection(async function (err, conn) {
      if (err) {
        console.log("Error:", err);
      } else {
        try {
          const [result] = await conn.promise().query(`SELECT * FROM ${table}`);
          res.json(result);
        } catch (error) {
          console.error("Error fetching records:", error);
          res.status(500).send(error);
        } finally {
          conn.release();
        }
      }
    });
  } else if (table && selectedfields && !fields && !values) {
    //return all records of table with specified columns of table

    if (!validTables.includes(table)) {
      console.log("Invalid table name");
      res.status(400).json({ Error: "Invalid table name" });
    }

    const selectParameters = selectedfields.join(" , ");
    con.getConnection(async function (err, conn) {
      if (err) {
        console.log("Error:", err);
      } else {
        try {
          const query = `SELECT ${selectParameters} FROM ${table}`;
          console.log(query);
          const [result] = await conn.promise().query(query);
          res.status(202).json(result);
        } catch (err) {
          console.error("Error fetching records:", err);
          res.status(500).send(err);
        } finally {
          conn.release();
        }
      }
    });
  } else if (table && !selectedfields && fields && values) {
    // return the records where condition met with all columns of table
    if (!validTables.includes(table)) {
      console.log("Invalid table name");
      res.status(400).json({ Error: "Invalid table name" });
    }

    const queryParameters = [];
    const parameterPlaceholders = [];

    for (let i = 0; i < fields.length; i++) {
      queryParameters.push(`${fields[i]}= ?`);
      parameterPlaceholders.push(values[i]);
    }

    const joinParts = queryParameters.join(" AND ");

    con.getConnection(async function (err, conn) {
      if (err) {
        console.log("Error:", err);
      } else {
        try {
          const query = `SELECT * FROM ${table} WHERE ${joinParts}`;
          console.log(query);
          const [result] = await conn
            .promise()
            .query(query, parameterPlaceholders);
          res.status(202).json(result);
        } catch (err) {
          console.error("Error fetching records:", err);
          res.status(500).send(err);
        } finally {
          conn.release();
        }
      }
    });
  } else {
    // return the records where condition met with specified columns of table
    if (!validTables.includes(table)) {
      console.log("Invalid table name");
      res.status(400).json({ Error: "Invalid table name" });
    }

    const queryParameters = [];
    const parameterPlaceholders = [];

    for (let i = 0; i < fields.length; i++) {
      if(fields[i] === "rate")
      {
        queryParameters.push(`${fields[i]} >=?`);
        parameterPlaceholders.push(values[i]);
      }
      else if(fields[i] === "rateMax"){
        queryParameters.push(`rate <=?`);
        parameterPlaceholders.push(values[i]);
      }
      else if(fields[i] === "tags" || fields[i] === "amenities")
      {
        queryParameters.push(`${fields[i]} LIKE ?`);
        parameterPlaceholders.push("%"+values[i]+"%");
      }
      else{
        queryParameters.push(`${fields[i]}=?`);
        parameterPlaceholders.push(values[i]);
      }
   
    }

    const joinParts = queryParameters.join(" AND ");
    const selectParameters = selectedfields.join(" , ");

    con.getConnection(async function (err, conn) {
      if (err) {
        console.log("Error:", err);
      } else {
        try {
          const query = `SELECT ${selectParameters} FROM ${table} WHERE ${joinParts}`;
          console.log(query);
          const [result] = await conn
            .promise()
            .query(query, parameterPlaceholders);
          res.status(202).json(result);
        } catch (err) {
          console.error("Error fetching records:", err);
          res.status(500).send(err);
        } finally {
          conn.release();
        }
      }
    });
  }
};

myController.packageData = async (req, res) => {
  const { condition, id } = req.body;
  console.log("Calling package data");
  console.log(req.body);

  if (!condition) {
    console.log("Invalid Data, No Condition!");

    res.status(400).json({ message: "Invalid Data, No Condition!" });
  }
  if (condition === "count")
  {
    con.getConnection(async function (err, conn) {
      if (err) {
        console.log("Error:", err);
      } else {
        try {
          console.log("Count Executed");
          const pQuery = `
          SELECT COUNT(*) as count FROM phtView;
          `;

          const [result] = await conn.promise().query(pQuery);
          if (result) {
            console.log("Count fetched!");
            res.status(202).json(result);
          }
        } catch (err) {
          console.log(
            "Error in fetching records with condition provided : ",
            err
          );
          res.status(500).send(err);
        } finally {
          conn.release();
        }
      }
    });
  }
  if (condition === "listing") {
    if (id) {
      con.getConnection(async function (err, conn) {
        if (err) {
          console.log("Error:", err);
        } else {
          try {
            const pQuery = `
          SELECT package_id,
          hotel_id,
          hotel_name,
          hotel_address,
          hotel_city,
          hotel_province,
          transport_id,
          make,
          model,
          vehicle_type,
          number_of_rooms,
          room_class,
          tags,
          rate,
          amenities,
          number_of_persons,
          transport_service,
          package_description,
          package_state,
          location,
          latitude,
          longitude,
          tripDuration,
          agentContact,
          package_name FROM phtView WHERE package_id=${id}`;

            const [result] = await conn.promise().query(pQuery);
            if (result) {
              console.log("Records fetched!");
              res.status(202).json(result);
            }
          } catch (err) {
            console.log("Error in fetching records :  ", err);
            res.status(500).send(err);
          } finally {
            conn.release();
          }
        }
      });
    } else {
      con.getConnection(async function (err, conn) {
        if (err) {
          console.log("Error:", err);
        } else {
          try {
            const pQuery = `
          SELECT package_id, package_name, rate, tags, location FROM phtView order by package_id desc;
            `;

            const [result] = await conn.promise().query(pQuery);
            if (result) {
              console.log("Records fetched!");
              res.status(202).json(result);
            }
          } catch (err) {
            console.log(
              "Error in fetching records with condition provided : ",
              err
            );
            res.status(500).send(err);
          } finally {
            conn.release();
          }
        }
      });
    }
  } else if (condition == "images") {
    if (id) {
      con.getConnection(async function (err, conn) {
        if (err) {
          console.log("Error:", err);
        } else {
          try {
            const pQuery = `
          SELECT package_images FROM phtView WHERE package_id=${id}`;

            const [result] = await conn.promise().query(pQuery);
            if (result) {
              console.log(`Images fetched! for package no. ${id}`);
              res.status(202).json(result);
            }
          } catch (err) {
            console.log("Error in fetching images :  ", err);
            res.status(500).send(err);
          } finally {
            conn.release();
          }
        }
      });
    }
  } else if (condition == "trending") {
    con.getConnection(async function (err, conn) {
      if (err) {
        console.log(err);
      } else {
        try {
          const pQuery = `
        SELECT package_id, package_name, rate,location, tags FROM phtView ORDER BY package_id DESC LIMIT 6;
          `;

          const [result] = await conn.promise().query(pQuery);
          if (result) {
            console.log("Records fetched!");
            res.status(202).json(result);
          }
        } catch (err) {
          console.log(
            "Error in fetching records with condition provided : ",
            err
          );
          res.status(500).send(err);
        } finally {
          conn.release();
        }
      }
    });
  }
  else if(condition === "trending-packages"){
    con.getConnection(async function (err, conn) {
      if (err) {
        console.log(err);
      } else {
        try {
          const pQuery = `
        SELECT package_id, package_name, rate, location, tags FROM phtView ORDER BY package_id DESC LIMIT 3;
          `;

          const [result] = await conn.promise().query(pQuery);
          if (result) {
            console.log("Records fetched!");
            res.status(202).json(result);
          }
        } catch (err) {
          console.log(
            "Error in fetching records with condition provided : ",
            err
          );
          res.status(500).send(err);
        } finally {
          conn.release();
        }
      }
    });
  } else if (condition === "trending2" && id) {
    con.getConnection(async function (err, conn) {
      if (err) {
        console.log(err);
      } else {
        try {
          const pQuery = `
        SELECT package_id, package_name, rate, hotel_city, location, tags, number_of_persons FROM phtView Where agentId = ${id};
          `;

          const [result] = await conn.promise().query(pQuery);
          if (result) {
            console.log("Records fetched!(Packages of Agent");
            res.status(202).json(result);
          }
        } catch (err) {
          console.log(
            "Error in fetching records with condition provided : ",
            err
          );
          res.status(500).send(err);
        } finally {
          conn.release();
        }
      }
    });
  }
  else if(condition === "trending2_thumbnail" && id)
  {
    con.getConnection(async function (err, conn) {
      if (err) {
        console.log(err);
      } else {
        try {
          const pQuery = `
        SELECT package_thumbnail FROM phtView Where agentId = ${id};
          `;

          const [result] = await conn.promise().query(pQuery);
          if (result) {
            console.log("Thumbnails fetched!(Packages of Agent)");
            res.status(202).json(result);
          }
        } catch (err) {
          console.log(
            "Error in fetching agent package thumbnails with provided condition : ",
            err
          );
          res.status(500).send(err);
        } finally {
          conn.release();
        }
      }
    });
  } 
  else if(condition === "package_thumbnails")
  {
    con.getConnection(async function (err, conn) {
      if (err) {
        console.log(err);
      } else {
        try {
          const pQuery = `
        SELECT package_thumbnail FROM phtView ORDER BY package_id DESC LIMIT 6;
          `;

          const [result] = await conn.promise().query(pQuery);
          if (result) {
            console.log("Packages Thumbnails Fetched!");
            res.status(202).json(result);
          }
        } catch (err) {
          console.log(
            "Error in fetching packages thumbnails with condition provided : ",
            err
          );
          res.status(500).send(err);
        } finally {
          conn.release();
        }
      }
    });
  }
  else if(condition === "package_thumbnails_all")
  {
    con.getConnection(async function (err, conn) {
      if (err) {
        console.log(err);
      } else {
        try {
          const pQuery = `
        SELECT package_thumbnail FROM phtView ORDER BY package_id DESC;
          `;

          const [result] = await conn.promise().query(pQuery);
          if (result) {
            console.log("All Packages Thumbnails Fetched!");
            res.status(202).json(result);
          }
        } catch (err) {
          console.log(
            "Error in fetching all packages thumbnails with condition provided : ",
            err
          );
          res.status(500).send(err);
        } finally {
          conn.release();
        }
      }
    });
  }
  else if(condition === "trending-packages-thumbnails"){
    con.getConnection(async function (err, conn) {
      if (err) {
        console.log(err);
      } else {
        try {
          const pQuery = `
        SELECT package_thumbnail FROM phtView ORDER BY package_id DESC LIMIT 3;
          `;

          const [result] = await conn.promise().query(pQuery);
          if (result) {
            console.log("Trending Packages Thumbnails Fetched!");
            res.status(202).json(result);
          }
        } catch (err) {
          console.log(
            "Error in fetching trending packages thumbnails with condition provided : ",
            err
          );
          res.status(500).send(err);
        } finally {
          conn.release();
        }
      }
    });
  }
};

myController.forgotpassword = async (req, res) => {
  const {email} = req.body;
  console.log(email);

  con.getConnection(async function (err, conn){
    if(err)
    {
      console.log("Error in establishing connection " , err);
      res.status(500).json({ message: "Error in establishing db connection" });
    }
    else{
      try{
        const query = `SELECT * FROM users WHERE email = ?`;
        const [result] = await conn.promise().query(query , email);
        console.log("This is result ",result[0].id)
        if(result.length > 0 && result[0].id){
          console.log("Email of user exist ");
          const token = jwt.sign({id : result[0].id} ,"this_is_jwt_secret_key", {expiresIn:"1d"});
          console.log("Token is ", token);
          const message = `Hello,\nPlease click on the URL below to reset the password.\nThis URL is valid for 24 hours.Please, do reset your password in 24 hours.\n\nhttps://beta.hamrah.pk/resetpassword/${result[0].id}/${token}\n\n\nRegards\nTeam Hamrah.`;
                await sendEmailToAgent({
                  email: email,
                  subject: 'Hamrah Reset Password Link',
                  message
                });
          res.status(202).send({Status : "Success"});        
        }
        else{
          console.log("Email not found");
          res.status(404).json({ message : "Email not found"})
        }
      }catch(error)
      {
        console.log(error)
      }
      finally{
        conn.release();
      }
    }
  })
}

myController.resetpassword = async (req, res) => {
  const {id , token} = req.params;
  const {password} = req.body;
  console.log(req.params);
  jwt.verify(token , "this_is_jwt_secret_key", (err , decoded)=>{
    if(err)
    {
      res.status(401).json({ Status: "Token Invalid", message: "Invalid Token", error: err });
    }
    else{
      con.getConnection( async function (err , conn){
        if(err)
        {
          console,log("Error in establishing connection " , err);
          res.status(500).json({ message: "Error in establishing db connection" });
        }
        else{
          try{
            const query = `UPDATE users SET password =? WHERE id = ?`;
            const [result] = await conn.promise().query(query ,[password, id]);
            if(result){
              console.log("Password Reset");
              res.status(202).json({ Status: "Success" });   
            }
            else{
              console.log("Failed to rest password");
              res.status(404).json({ Status: "Failed", message : "Failed to reset password"})
            }
          }catch(error)
          {
            console.log(error)
            res.status(404).json({ Status: "Failed", message: "Failed to reset password", error: error });
          }
          finally{
            conn.release();
          }
        }
      })
    }
  })
}

myController.filterDropDown = async (req , res) => {
  con.getConnection( async function (err , conn){
    if(err)
    {
      res.status(500).json({message : "Error while cnnectiong to db : ", err});
    }
    else{
      try{
        const query = "SELECT package_id, hotel_name, tags, rate, amenities, transport_service, location, tripDuration, number_of_persons  FROM phtView";
        const [result] = await conn.promise().query(query);
        if(result)
        {
          console.log("Data from filterView", result);
          res.json(result);
        }
        else{
          res.status(404).json({message :"Data not found"})
        }
      }
      catch(err)
      {
        res.status(404).json({message :err});
      }
      finally{
        conn.release();
      }
    }
  })
}

module.exports = myController;

// myController.create = async (req, res) => {
//   const { table, data } = req.body;
//   console.log(table, data);
//   const reqFields = {
//     hotels: [
//       "name",
//       "address",
//       "city",
//       "province",
//       "focalperson",
//       "contact",
//       "email",
//       "rating",
//     ],
//     rooms: [
//       "rclass",
//       "quantity",
//       "available",
//       "description",
//       "rate",
//       "hotelid",
//     ],
//     transport: [
//       "name",
//       "make",
//       "model",
//       "vehicle_type",
//       "seats",
//       "exclusive",
//       "rate",
//       "focalperson",
//       "contact",
//       "email",
//       "roundtrip",
//     ],
//     packages: [
//       "hotel_id",
//       "number_of_rooms",
//       "room_class",
//       "number_of_persons",
//       "transport_service_id",
//       "tag",
//       "amenities",
//       "rate",
//     ],
//   };
//   if (!reqFields[table]) {
//     console.log("Invalid Table Name");
//     return res.status(400).json({ message: "Invalid table name" });
//   }

//   const missingFields = reqFields[table].filter((fields) => !(fields in data));
//   if (missingFields.length > 0) {
//     console.log("Invalid Data");
//     return res.status(400).json({
//       message: `Missing required fields : ${missingFields.join(",")}`,
//     });
//   }

//   try {
//     const fields = reqFields[table].join(",");
//     const placeholders = reqFields[table]
//       .map((field, index) => `$${index + 1}`)
//       .join(",");
//     const values = reqFields[table].map((field) => data[field]);
//     const insertQuery = `INSERT INTO ${table} (${fields})VALUES(${placeholders}) RETURNING id`;

//     const result = await client.query(insertQuery, values);
//     res.status(201).json({
//       message: `Record of ${table} created successfully`,
//       insertedId: result.rows[0].id,
//     });
//   } catch (err) {
//     console.log("Error : ", err);
//     return res.status(500).json({ message: "Internal Server Error" });
//   }
// };

// // This API will update the record of all the table , Remember to specify the table name when calling this API

// myController.updateRecord = async (req, res) => {
//   const { table, id, ...updateFields } = req.body;
//   console.log(table, id, updateFields);

//   if (!table || !id || Object.keys(updateFields).length === 0) {
//     return res.status(400).json({ message: "Please Provide Proper Details" });
//   }

//   const validTables = ["hotels", "rooms", "transport", "packages"];
//   if (!validTables.includes(table)) {
//     return res.status(400).json({ message: "Invalid table Name" });
//   }

//   try {
//     const updateQueryParts = [];
//     const queryParams = [id];
//     let paramIndex = 2;

//     for (const fields in updateFields) {
//       updateQueryParts.push(`${fields}=$${paramIndex}`);
//       queryParams.push(updateFields[fields]); // passes key(field) in the object and it returns the value for the key
//       paramIndex++;
//     }

//     console.log(updateQueryParts, queryParams, paramIndex);
//     const updateQuery = `UPDATE ${table} SET ${updateQueryParts.join(
//       ","
//     )} WHERE id=$1`;
//     await client.query(updateQuery, queryParams);
//     res.status(202).json({ message: "Updated Successfully!" });
//     console.log("Updated Successfully!");
//   } catch (err) {
//     console.log("Error in updating hotel record : ", err);
//     res.status(204).send("Internal Server Error");
//   }
// };

// // API to delete the record just pass the id of the record and the table name

// myController.deleteRecord = async (req, res) => {
//   const { table, id } = req.body;
//   console.log(table, id);

//   if (!id || !table) {
//     console.log("Please provide proper details");
//     return res.status(400).json({ message: "Please provide proper details" });
//   } else {
//     try {
//       const findQuery = `SELECT * FROM ${table} WHERE id=$1`;
//       const r = await client.query(findQuery, [id]);
//       if (r.rowCount === 1) {
//         const deleteQuery = `DELETE FROM ${table} WHERE id=$1`;
//         await client.query(deleteQuery, [id]);
//         res
//           .status(202)
//           .json({ message: `${table} Record deleted Successfully!` });
//         console.log(`${table} Record deleted Successfully!`);
//       } else {
//         res.status(404).json({ message: `${table}  Record NOT Found!` });
//         console.log(`${table} Record NOT Found!`);
//       }
//     } catch (err) {
//       console.log("Error : ", err);
//       res.status(500).send("Internal Server Error");
//     }
//   }
// };

// //getting all Record for each tables or Filtered Record

// // myController.filter = async (req, res) => {
// //     const { table, fields, values } = req.body;

// //     if (!table || !fields || !values || fields.length !== values.length || fields.length === 0) {
// //         console.log("Please provide proper data!");
// //         return res.status(400).json({ message: "Please provide proper data!" });
// //     }

// //     const validTables = ["hotels", "rooms", "transport", "packages"];
// //     if (!validTables.includes(table)) {
// //         return res.status(400).json({ message: "Invalid table Name" });
// //     }

// //     const queryParams = [];
// //     const paramPlaceholders = [];

// //     for (let i = 0; i < fields.length; i++) {
// //         queryParams.push(`${fields[i]} = $${i + 1}`);
// //         paramPlaceholders.push(values[i]);
// //     }

// //     const whereClause = queryParams.join(' AND ');

// // try {
// //     const query = `SELECT * FROM ${table} WHERE ${whereClause}`;
// //     console.log(query);
// //     const result = await client.query(query, paramPlaceholders);
// //     res.json(result.rows);
// // } catch (err) {
// //     console.error('Error fetching records:', err);
// //     res.status(500).send('Internal Server Error');
// // }
// // }

// // This Api filter the data from the specified table

// myController.filter = async (req, res) => {
//   const { table, selectedfields, fields, values } = req.body;
//   console.log(req.body);

//   if (!table) {
//     console.log("Your request is not Valid");
//     res.status(400).json({ Error: "Your request is not Valid" });
//   } else if (table && !selectedfields && !fields && !values) {
//     // return all the records of the table with all columns of table

//     if (!validTables.includes(table)) {
//       console.log("Invalid table name");
//       res.status(400).json({ Error: "Invalid table name" });
//     }

//     try {
//       const result = await client.query(`SELECT * FROM ${table}`);
//       res.json(result);
//     } catch (error) {
//       console.error("Error fetching records:", error);
//       res.status(500).send("Internal Server Error");
//     }
//   } else if (table && selectedfields && !fields && !values) {
//     //return all records of table with specified columns of table

//     if (!validTables.includes(table)) {
//       console.log("Invalid table name");
//       res.status(400).json({ Error: "Invalid table name" });
//     }

//     const selectParameters = selectedfields.join(" , ");
//     try {
//       const query = `SELECT ${selectParameters} FROM ${table}`;
//       console.log(query);
//       const result = await client.query(query);
//       res.status(202).json(result.rows);
//     } catch (err) {
//       console.error("Error fetching records:", err);
//       res.status(500).send("Internal Server Error");
//     }
//   } else if (table && !selectedfields && fields && values) {
//     // return the records where condition met with all columns of table
//     if (!validTables.includes(table)) {
//       console.log("Invalid table name");
//       res.status(400).json({ Error: "Invalid table name" });
//     }

//     const queryParameters = [];
//     const parameterPlaceholders = [];

//     for (let i = 0; i < fields.length; i++) {
//       queryParameters.push(`${fields[i]}=$${i + 1}`);
//       parameterPlaceholders.push(values[i]);
//     }

//     const joinParts = queryParameters.join(" AND ");

//     try {
//       const query = `SELECT * FROM ${table} WHERE ${joinParts}`;
//       console.log(query);
//       const result = await client.query(query, parameterPlaceholders);
//       res.status(202).json(result.rows);
//     } catch (err) {
//       console.error("Error fetching records:", err);
//       res.status(500).send("Internal Server Error");
//     }
//   } else {
//     // return the records where condition met with specified columns of table
//     if (!validTables.includes(table)) {
//       console.log("Invalid table name");
//       res.status(400).json({ Error: "Invalid table name" });
//     }

//     const queryParameters = [];
//     const parameterPlaceholders = [];

//     for (let i = 0; i < fields.length; i++) {
//       queryParameters.push(`${fields[i]}=$${i + 1}`);
//       parameterPlaceholders.push(values[i]);
//     }

//     const joinParts = queryParameters.join(" AND ");
//     const selectParameters = selectedfields.join(" , ");

//     try {
//       const query = `SELECT ${selectParameters} FROM ${table} WHERE ${joinParts}`;
//       console.log(query);
//       const result = await client.query(query, parameterPlaceholders);
//       res.status(202).json(result.rows);
//     } catch (err) {
//       console.error("Error fetching records:", err);
//       res.status(500).send("Internal Server Error");
//     }
//   }
// };

// // Query will use VIEW name phtView

// myController.packageData = async (req, res) => {
//   const { condition, id } = req.body;
//   console.log(req.body);

//   if (!condition) {
//     console.log("Invalid Data");
//     res.status(400).json({ message: "Invalid Data" });
//   }
//   if (condition == "listing") {
//     if (id) {
//       try {
//         const pQuery = `
//                   SELECT * FROM phtView where package_id = '${id}'
//               `;

//         const result = await client.query(pQuery);
//         if (result) {
//           console.log("Records fetched!");
//           res.status(202).json(result);
//         }
//       } catch (err) {
//         console.log("Error in fetching records");
//         res.status(500).send("Internal Server Error");
//       }
//     } else {
//       try {
//         const pQuery = `
//               SELECT * FROM phtView order by package_id
//           `;

//         const result = await client.query(pQuery);
//         if (result) {
//           console.log("Records fetched!");
//           res.status(202).json(result);
//         }
//       } catch (err) {
//         console.log("Error in fetching records");
//         res.status(500).send("Internal Server Error");
//       }
//     }
//   }
// };
// // myController.packageData = async (req, res) => {
// //   const { condition, id } = req.body;
// //   console.log(req.body);

// //   if (!condition) {
// //     console.log("Invalid Data");
// //     res.status(400).json({ message: "Invalid Data" });
// //   }
// //   if (condition == "listing") {
// //     if (id) {
// //       try {
// //         const pQuery = `
//               SELECT
//               p.id AS package_id,
//               p.tag as tags,
//               p.hotel_id,
//               h.name AS hotel_name,
//               h.address AS hotel_address,
//               h.city AS hotel_city,
//               h.province AS hotel_province,
//               t.id as transport_id,
//               t.make,
//               t.model,
//               t.vehicle_type,
//               t.name as transport_name,
//               p.number_of_persons,
//               p.room_class,
//               p.amenities,
//               p.rate

//           FROM
//               packages p
//           INNER JOIN
//               hotels h ON p.hotel_id = h.id
//           INNER JOIN
//               transport t ON p.transport_service_id = t.id
//           WHERE
//               p.id=${id};
// //           `;

// //         const result = await client.query(pQuery);
// //         if (result) {
// //           console.log("Records fetched!");
// //           res.status(202).json(result);
// //         }
// //       } catch (err) {
// //         console.log(err);
// //         console.log("Error in fetching records");
// //         res.status(500).send("Internal Server Error");
// //       }
// //     } else {
// //       try {
// //         const pQuery = `
// //               SELECT
// //               p.id AS package_id,
// //               p.tag as tags,
// //               p.hotel_id,
// //               h.name AS hotel_name,
// //               h.address AS hotel_address,
// //               h.city AS hotel_city,
// //               h.province AS hotel_province,
// //               t.id as transport_id,
// //               t.make,
// //               t.model,
// //               t.vehicle_type,
// //               t.name as transport_name,
// //               p.number_of_persons,
// //               p.room_class,
// //               p.amenities,
// //               p.rate

// //           FROM
// //               packages p
// //           INNER JOIN
// //               hotels h ON p.hotel_id = h.id
// //           INNER JOIN
// //               transport t ON p.transport_service_id = t.id;
// //           `;

// //         const result = await client.query(pQuery);
// //         if (result) {
// //           console.log("Records fetched!");
// //           res.status(202).json(result);
// //         }
// //       } catch (err) {
// //         console.log(err);
// //         console.log("Error in fetching records");
// //         res.status(500).send("Internal Server Error");
// //       }
// //     }
// //   }
// // };

// module.exports = myController;

const constructSearchTerms = (terms, field) => {
  temp = "";
  terms.map((term, i) => {
    if (i == 0) {
      temp =
        temp + `${field} SOUNDS LIKE '${term}' OR ${field} LIKE '%${term}%'`;
    } else {
      temp =
        temp +
        ` OR ${field} SOUNDS LIKE '${term}' OR ${field} LIKE '%${term}%'`;
    }
  });
  return temp;
};
