const { con } = require('../db/conn');

const ctTransport = async (name) => {
    try {
        const createTableQuery = `
        CREATE TABLE ${name} (
            id INT AUTO_INCREMENT PRIMARY KEY,
            name VARCHAR(255) UNIQUE NOT NULL,
            make VARCHAR(255) NOT NULL,
            model VARCHAR(255) NOT NULL,
            vehicle_type VARCHAR(50) NOT NULL,
            seats INT NOT NULL,
            exclusive BOOLEAN NOT NULL,
            rate DECIMAL(10,2) NOT NULL,
            focalperson VARCHAR(255) NOT NULL,
            contact VARCHAR(20) NOT NULL,
            email VARCHAR(255) NOT NULL,
            roundtrip BOOLEAN NOT NULL
        )
    `;

        await con.promise().query(createTableQuery);
        console.log(`Table ${name} Created!`);
    } catch (err) {
        console.log("Error: ", err);
    }
};

module.exports = ctTransport;


// const {getClient} = require('../db/conn')

// const ctTransport = async (name)=>{
//     try{
//         const client=getClient();
//         const createTableQuery = ` 
//         CREATE TABLE ${name} (
//             id serial PRIMARY KEY,
//             name VARCHAR(255) UNIQUE NOT NULL,
//             make VARCHAR(255) NOT NULL,
//             model VARCHAR(255) NOT NULL,
//             vehicle_type VARCHAR(50) NOT NULL,
//             seats INTEGER NOT NULL,
//             exclusive BOOLEAN NOT NULL,
//             rate NUMERIC(10,2) NOT NULL,
//             focalperson VARCHAR(255) NOT NULL,
//             contact VARCHAR(20) NOT NULL,
//             email VARCHAR(255) NOT NULL,
//             roundtrip BOOLEAN NOT NULL
//         )
//     `;

//     await client.query(createTableQuery);
//     console.log(`Table ${name} Created!`);
//     }catch(err)
//     {
//         console.log("Error : ", err);
//     }
// };

// module.exports=ctTransport;