const Pool = require("pg").Pool;

const pool = new Pool({
  user: "me",
  host: "localhost",
  database: "api",
  password: "habibi",
  port: 5432,
});

const queries = {
  getUsers: async (request, response) => {
    await pool.query(
      "SELECT * FROM users ORDER BY id ASC",
      (error, results) => {
        if (error) {
          throw error;
        }
        response.status(200).json(results.rows);
        console.log("Habibi");
      }
    );
  },
  getUserById: (request, response) => {
    const id = parseInt(request.params.id);
    pool.query("SELECT * FROM users WHERE id = $1", [id], (error, results) => {
      if (error) {
        throw error;
      }
      response.status(200).json(results.rows);
    });
  },
  createUser: (request, response) => {
    const { name, email } = request.body;

    pool.query(
      "INSERT INTO users (name, email) VALUES ($1, $2) RETURNING *",
      [name, email],
      (error, results) => {
        if (error) {
          throw error;
        }
        response.status(201).send(`User added with ID: ${results.rows[0].id}`);
      }
    );
  },
  updateUser: (request, response) => {
    const id = parseInt(request.params.id);
    const { name, email } = request.body;

    pool.query(
      "UPDATE users SET name = $1, email = $2 WHERE id = $3",
      [name, email, id],
      (error, results) => {
        if (error) {
          throw error;
        }
        response.status(200).send(`User modified with ID: ${id}`);
      }
    );
  },
  deleteUser: (request, response) => {
    const id = parseInt(request.params.id);

    pool.query("DELETE FROM users WHERE id = $1", [id], (error, results) => {
      if (error) {
        throw error;
      }
      response.status(200).send(`User deleted with ID: ${id}`);
    });
  },
  createTable: async (req, res) => {
    await pool.query(
      `CREATE TABLE hotels (
        id SERIAL PRIMARY KEY,
        name VARCHAR(255) NOT NULL,
        address VARCHAR(255) NOT NULL,
        city VARCHAR(100) NOT NULL,
        province VARCHAR(100) NOT NULL,
        FocalPerson VARCHAR(255),
        contact VARCHAR(20),
        email VARCHAR(255),
        rating INTEGER CHECK (rating >= 1 AND rating <= 5)
    );
    `,
      "",
      (err, results) => {
        if (err) {
          throw err;
        }
        res.status(200).send("Table Created");
      }
    );
  },
  getAllHotels: async (req, res) => {
    await pool.query("Select * from hotels", "", (err, results) => {
      if (err) {
        throw err;
      }
      console.log(results);
      res.status(200).send(results.rows);
    });
  },
  getRooms: async (req, res) => {
    const id = parseInt(req.body.id);
    console.log(id, typeof id);
    await pool.query(
      "Select * from rooms Where hotelid=$1",
      [id],
      (err, results) => {
        if (err) {
          throw err;
        }
        console.log(results);
        res.status(200).send(results.rows);
      }
    );
  },
};
module.exports = queries;
